//
//  SwipesViewController.m
//  Swipes
//
//  Created by Robert Górczyński on 11-07-25.
//

#import "SwipesViewController.h"

#define kMinimumGestureLength    25 
#define kMaximumVariance         5 


@implementation SwipesViewController
@synthesize label; 
@synthesize gestureStartPoint; 

- (void)eraseText { 
    label.text = @""; 
} 

// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	UISwipeGestureRecognizer *vertical = [[[UISwipeGestureRecognizer alloc]  
										   initWithTarget:self action:@selector(reportVerticalSwipe:)] autorelease]; 
    vertical.direction = UISwipeGestureRecognizerDirectionUp|  
	UISwipeGestureRecognizerDirectionDown; 
    [self.view addGestureRecognizer:vertical]; 
	
    UISwipeGestureRecognizer *horizontal = [[[UISwipeGestureRecognizer alloc]  
											 initWithTarget:self action:@selector(reportHorizontalSwipe:)] autorelease]; 
    horizontal.direction = UISwipeGestureRecognizerDirectionLeft|  
	UISwipeGestureRecognizerDirectionRight; 
    [self.view addGestureRecognizer:horizontal]; 	
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.label = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
    [label release]; 
    [super dealloc];
}

#pragma mark - 
- (void)reportHorizontalSwipe:(UIGestureRecognizer *)recognizer { 
	label.text = @"Wykryto machnięcie poziome"; 
	[self performSelector:@selector(eraseText) withObject:nil afterDelay:2]; 
} 

- (void)reportVerticalSwipe:(UIGestureRecognizer *)recognizer { 
	label.text = @"Wykryto machnięcie pionowe"; 
	[self performSelector:@selector(eraseText) withObject:nil afterDelay:2]; 
}


@end
